Attribute VB_Name = "Funktionen"

Rem DLL-Deklarationen zur DLL SLHDMX32.DLL fr VB4/32 und VB5
Rem Declarations of the 32Bit DLL SLHDMX32.DLL

Rem SLH-DMX-Funktionen fr Interfacekarte 1512A/1512B/1512C
Rem Functions for PC Interface Cards 1512A/1512B/1512C

Declare Function vbCardadr Lib "SLHDMX32.DLL" Alias "vbCardAdr" (ByVal EGAL As Integer) As Long
'Adresse der DMX-Karte im Rechner ermitteln
'Aufrufwert: beliebig (egal)
'Rckgabewert: Kartenadresse
'Checks for presence of card, returns the card address
'calling parameter: (any value)

Declare Function vbWByte Lib "SLHDMX32.DLL" (ByVal KARTENADR As Integer, ByVal RAMADR As Integer, ByVal DATABYTE As Integer) As Long
'Schreibt einen Wert in die DMX-Karte mit der angegebenen Kartenadresse,
'an die angebene RAM-Adresse innerhalb der Karte.
'Die RAM-Adrebelegung ist an anderer Stelle beschrieben.
'Rckgabewert: dummy
'Writes a value to the card at the specified card address; the value
'will be written into the specified Card RAM location.
'See the manual for Card RAM specification
'This function returns a dummy value

Declare Function vbRByte Lib "SLHDMX32.DLL" (ByVal KARTENADR As Integer, ByVal RAMADR As Integer) As Long
'Liest einen Wert aus der DMX-Karte mit der angegebenen Kartenadresse,
'aus der angebenen RAM-Adresse innerhalb der Karte.
'Die RAM-Adrebelegung ist an anderer Stelle beschrieben.
'Rckgabewert: gelesenes Byte
'Reads a value from the card at the specified card address; the value
'is read from the specified Card RAM location.
'See the manual for Card RAM specification
'This functions returns a byte

Declare Function vbDMXStart Lib "SLHDMX32.DLL" (ByVal KARTENADR As Integer) As Long
'Startet die bertragung der DMX-Karte
'Rckgabewert: dummy
'starts the DMX transmission. Calling parameter=Card Address, Return parameter=dummy

Declare Function vbDMXStop Lib "SLHDMX32.DLL" (ByVal KARTENADR As Integer) As Long
'Beendet die bertragung der DMX-Karte
'Rckgabewert: dummy
'stops the DMX transmission. Calling parameter=Card Address, Return parameter=dummy




'------------------------------------------------------------------
'Die folgenden Variablen sind fr die Beispielprogramme deklariert
'Declaration of variables for the demo programs
'------------------------------------------------------------------
Public Dateiname As String
Public BSystemLnge As Integer

Public Index As Integer

Public i As Integer, n As Integer       ' allgemeine Indexvariablen
                                        ' general public indices

Public DMXAUSGABE(0 To 5)  As Integer   ' Ausgabewert
                                        ' DMX Output Value
                                        
Public Patcheintrag(0 To 5) As Integer  'Patchtabelle

Public DMXOUT(0 To 512) As Integer      ' DMX-Datenarray
                                        ' DMX Data Array

Public AlterWert As Integer             ' Merkregister
Public AlterUWert As Integer            ' Scratchpad

Public Memory(0 To 5, 0 To 5) As Integer
Public STOFLG As Integer                'Merkflag: "Speichern"

'neu hinzu:

Public CHSFLG As Integer                'Merkflag: CHASER EIN
Public CHSTEP As Integer                'Stepnummer 0...99
Public MaxStep As Integer               'die Anzahl gespeicherter Steps
Public Chasout(0 To 5) As Integer       'Chaser-Ausgaberegister
Public Chaser(0 To 99, 0 To 5)  As Integer  'Chaser Memory fr +99 Steps

'------------------------------------------------------------------
'variables for PC-card
'------------------------------------------------------------------
'required:
Public cardadr As Long                  ' word: Kartenadresse im PC
                                        ' word: card address
Public dmxdef(0 To 9) As Integer        ' Hardware-Initialisierungswerte
                                        ' parameters for hardware initialization (see manual)

Public Function BetriebssystemLaden(Dateiname$)

Dim File As Integer
Dim i As Integer
Dim BSys As Byte
Dim Dummy1 As Integer, Dummy2 As Integer

'Texte fr die Debug-Ausgabe
BText = ""
BSystemLnge = 0


cardadr = vbCardadr(0)    'Kartenadresse ermitteln
If cardadr > &HFF Then    'wenn Karte vorhanden, dann...
  File = FreeFile
  Open Dateiname$ For Binary Access Read As #File
  For i = 1 To LOF(File)
    Seek #1, i
    Get #1, , BSys                                'Datei Byte fr Byte lesen
    Dummy1 = vbWByte(cardadr, i - 1, Val(BSys))   'und in Karte schreiben
    Dummy2 = vbRByte(cardadr, i - 1)              'zur Kontrolle aus Karte zurcklesen
    If Val(BSys) <> Dummy2 Then                   'und prfen ob okay
      Debug.Print i - 1; ";"; Str$(Val(BSys)); "-";
      Debug.Print Dummy2; "  bertragungsfehler!"
    End If
  Next i
  
  Close #File
  
  BSystemLnge = i - 1                            'fr Anzeige
  

End If

End Function




